import type { Stringer } from "./api.js";
/**
 * Returns stringer which pads given input with `ch` (default: space) on
 * both sides and returns fixed width string of given `lineWidth`.
 * Returns string of only pad characters for any `null` or `undefined`
 * values. If the string version of an input is > `lineWidth`, no
 * centering is performed, but the string will be truncated to
 * `lineWidth`.
 *
 * Note: The padding string can contain multiple characters.
 *
 * @example
 * ```ts tangle:../export/center.ts
 * import { center } from "@thi.ng/strings";
 *
 * console.log(
 *   center(20, "<>")(" thi.ng ")
 * );
 * // "<><><> thi.ng <><><>"
 * ```
 *
 * @example
 * ```ts tangle:../export/center-2.ts
 * import { comp } from "@thi.ng/compose";
 * import { center, wrap } from "@thi.ng/strings";
 *
 * // compose formatting function
 * const fmt = comp(center(20,"<>"), wrap(" "));
 *
 * console.log(fmt("thi.ng"));
 * // "<><><> thi.ng <><><>"
 * ```
 *
 * @param lineWidth - target length
 * @param pad - pad character(s)
 */
export declare const center: (lineWidth: number, pad?: string | number) => Stringer<any>;
//# sourceMappingURL=center.d.ts.map