/**
 * @remarks
 * References:
 * - https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references
 * - https://www.w3.org/TR/xml-entity-names/byalpha.html
 */
export declare const ENTITIES: Record<string, string>;
export declare const RE_ENTITIES: RegExp;
export declare const ENTITIES_REV: Record<string, string>;
export declare const RE_ENTITIES_REV: RegExp;
export declare const RE_ENTITIES_NUM: RegExp;
/**
 * Replaces all occurrences of character keys in {@link ENTITIES} with their
 * named HTML entities.
 *
 * @remarks
 * Only use this function when targetting HTML output. For XML/SVG etc. use
 * {@link escapeEntitiesNum}.
 *
 * @param src
 */
export declare const escapeEntities: (src: string) => string;
/**
 * Similar to {@link escapeEntities}, but only uses _named_ entities for `&`,
 * `<`, `>`, `'`, `"` and numeric entities for all others.
 *
 * @remarks
 * This function is used as default by thi.ng/hiccup `serialize()` to escape
 * characters and ensure compatibility with XML (which by default only supports
 * named entities for the above 5 characters).
 *
 * @param src
 */
export declare const escapeEntitiesNum: (src: string) => string;
/**
 * Replace all known named and numeric entities with their original characters.
 * Opposite op of {@link escapeEntities} and {@link escapeEntitiesNum}.
 *
 * @param src
 */
export declare const unescapeEntities: (src: string) => string;
//# sourceMappingURL=entities.d.ts.map