import type { IObjectOf } from "@thi.ng/api";
/**
 * Object with whitespace characters as keys and their values set to
 * true. All others undefined.
 */
export declare const WS: IObjectOf<boolean>;
/**
 * Object with 0-9 characters as keys and their values set to true. All
 * others undefined.
 */
export declare const DIGITS: Readonly<IObjectOf<boolean>>;
/**
 * Object with hex digit characters (upper & lower case versions) as
 * keys and their values set to true. All others undefined.
 */
export declare const HEX: Readonly<IObjectOf<boolean>>;
/**
 * Object with ASCII lowercase characters as keys and their values set
 * to true. All others undefined.
 */
export declare const LOWER: Readonly<IObjectOf<boolean>>;
/**
 * Object with ASCII uppercase characters as keys and their values set
 * to true. All others undefined.
 */
export declare const UPPER: Readonly<IObjectOf<boolean>>;
/**
 * Combination of {@link UPPER} and {@link LOWER}.
 */
export declare const ALPHA: Readonly<{
    [x: string]: boolean;
}>;
/**
 * Combination of {@link ALPHA} and {@link DIGITS} and '_'.
 */
export declare const ALPHA_NUM: IObjectOf<boolean>;
/**
 * Object with ASCII punctuation characters as keys and their values set
 * to true. All others undefined.
 */
export declare const PUNCTUATION: Readonly<IObjectOf<boolean>>;
//# sourceMappingURL=groups.d.ts.map