import { charRange } from "./range.js";
const __defGroup = (...ranges) => {
  const acc = {};
  for (let range of ranges) {
    for (let c of range) {
      acc[c] = true;
    }
  }
  return Object.freeze(acc);
};
const WS = Object.freeze({
  "	": true,
  "\n": true,
  "\v": true,
  "\f": true,
  "\r": true,
  " ": true
});
const DIGITS = __defGroup(charRange("0", "9"));
const HEX = __defGroup(
  charRange("0", "9"),
  charRange("A", "F"),
  charRange("a", "f")
);
const LOWER = __defGroup(charRange("a", "z"));
const UPPER = __defGroup(charRange("A", "Z"));
const ALPHA = Object.freeze({ ...UPPER, ...LOWER });
const ALPHA_NUM = Object.freeze({
  ...ALPHA,
  ...DIGITS,
  _: true
});
const PUNCTUATION = __defGroup(
  charRange("!", "/"),
  charRange(":", "@"),
  charRange("[", "`"),
  charRange("{", "~")
);
export {
  ALPHA,
  ALPHA_NUM,
  DIGITS,
  HEX,
  LOWER,
  PUNCTUATION,
  UPPER,
  WS
};
