import { memoizeJ } from "@thi.ng/memoize/memoizej";
import { repeat } from "./repeat.js";
const padLeft = memoizeJ((n, ch = " ") => {
  const buf = repeat(String(ch), n);
  return (x, len) => {
    if (x == null) return buf;
    x = x.toString();
    len = len !== void 0 ? len : x.length;
    return len < n ? buf.substring(len) + x : x;
  };
});
const Z2 = padLeft(2, "0");
const Z3 = padLeft(3, "0");
const Z4 = padLeft(4, "0");
export {
  Z2,
  Z3,
  Z4,
  padLeft
};
