/**
 * Iterator version of `String.prototype.split()`. Yields iterable of substrings
 * of `src`, delimited by given regexp (default: unix & windows linebreaks).
 *
 * @remarks
 * Use this function to avoid creating an entire full copy of the original
 * source string, e.g. when only single-token or line-based accesses are needed.
 * This function is ~2x faster for large strings (benchmarked with 8MB & 16MB
 * inputs), with dramatically lower memory consumption.
 *
 * If given an regexp as `delim`, the function ensures the regexp has its global
 * flag enabled.
 *
 * @param src -
 * @param delim -
 * @param includeDelim -
 */
export declare function split(src: string, delim?: RegExp | string, includeDelim?: boolean): Generator<string, void, unknown>;
//# sourceMappingURL=split.d.ts.map