/**
 * Multi-line version of {@link tabsToSpacesLine}.
 *
 * @example
 * ```ts tangle:../export/tabs-to-spaces.ts
 * import { tabsToSpaces } from "@thi.ng/strings";
 *
 * console.log(
 *   tabsToSpaces("0\t1\t2", 10)
 *   + "\n" +
 *   tabsToSpaces("0\t45\t890\t\t6\t0")
 *   + "\n" +
 *   tabsToSpaces("^\t^\t^\t^\t^\t^")
 * );
 * // 0         1         2
 * // 0   45  890     6   0
 * // ^   ^   ^   ^   ^   ^
 * ```
 *
 * @param src -
 * @param tabSize -
 */
export declare const tabsToSpaces: (src: string, tabSize?: number) => string;
/**
 * Takes a single line string and converts all tab characters to spaces, using
 * given `tabSize` (default: 4).
 *
 * @param line -
 * @param tabSize -
 */
export declare const tabsToSpacesLine: (line: string, tabSize?: number) => string;
/**
 * Multi-line version of {@link spacesToTabsLine}.
 *
 * @param src -
 * @param tabSize -
 */
export declare const spacesToTabs: (src: string, tabSize?: number) => string;
/**
 * Takes a single line string and converts all tab characters to spaces, using
 * given `tabSize`. Inverse op of {@link tabsToSpacesLine}.
 *
 * @param line -
 * @param tabSize -
 */
export declare const spacesToTabsLine: (line: string, tabSize?: number) => string;
//# sourceMappingURL=tabs.d.ts.map