import type { Transducer, TxLike } from "./api.js";
/**
 * Transducer composition. Returns new transducer which applies given
 * transducers in left-to-right order.
 *
 * @remarks
 * Fast (loop-free) paths are provided for up to 10 args (transducers).
 */
export declare function comp<A, B>(a: TxLike<A, B>): Transducer<A, B>;
export declare function comp<A, B, C>(a: TxLike<A, B>, b: TxLike<B, C>): Transducer<A, C>;
export declare function comp<A, B, C, D>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>): Transducer<A, D>;
export declare function comp<A, B, C, D, E>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>): Transducer<A, E>;
export declare function comp<A, B, C, D, E, F>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>): Transducer<A, F>;
export declare function comp<A, B, C, D, E, F, G>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>): Transducer<A, G>;
export declare function comp<A, B, C, D, E, F, G, H>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>, g: TxLike<G, H>): Transducer<A, H>;
export declare function comp<A, B, C, D, E, F, G, H, I>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>, g: TxLike<G, H>, h: TxLike<H, I>): Transducer<A, I>;
export declare function comp<A, B, C, D, E, F, G, H, I, J>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>, g: TxLike<G, H>, h: TxLike<H, I>, i: TxLike<I, J>): Transducer<A, J>;
export declare function comp<A, B, C, D, E, F, G, H, I, J, K>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>, g: TxLike<G, H>, h: TxLike<H, I>, i: TxLike<I, J>, j: TxLike<J, K>): Transducer<A, K>;
export declare function comp<A, B, C, D, E, F, G, H, I, J, K>(a: TxLike<A, B>, b: TxLike<B, C>, c: TxLike<C, D>, d: TxLike<D, E>, e: TxLike<E, F>, f: TxLike<F, G>, g: TxLike<G, H>, h: TxLike<H, I>, i: TxLike<I, J>, j: TxLike<J, K>, ...fns: TxLike<any, any>[]): Transducer<A, any>;
//# sourceMappingURL=comp.d.ts.map