import { isFunction } from "@thi.ng/checks/is-function";
const deepTransform = (spec) => {
  if (isFunction(spec)) {
    return spec;
  }
  const mapfns = Object.keys(spec[1] || {}).reduce(
    (acc, k) => (acc[k] = deepTransform(spec[1][k]), acc),
    {}
  );
  return (x) => {
    const res = { ...x };
    for (let k in mapfns) {
      res[k] = mapfns[k](res[k]);
    }
    return spec[0](res);
  };
};
export {
  deepTransform
};
