import type { Fn, Fn0 } from "@thi.ng/api";
import type { Transducer } from "./api.js";
export interface DistinctOpts<T> {
    /**
     * Key extractor function.
     */
    key: Fn<T, any>;
    /**
     * Cache factory. Must produce a ES6 Set-like instance used to keep
     * track of seen key values.
     */
    cache: Fn0<Set<any>>;
}
/**
 * Stateful transducer. Removes any duplicate input values by keeping an
 * internal cache (user configurable) of previously seen inputs. See
 * {@link DistinctOpts}.
 *
 * @example
 * ```ts tangle:../export/distinct.ts
 * import { distinct } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...distinct({ key: (x) => x.id }, [{id: 1, x: 2}, {id: 1, x: 3}])]
 * );
 * // [ { id: 1, x: 2 } ]
 * ```
 *
 * @param opts -
 */
export declare function distinct<T>(opts?: Partial<DistinctOpts<T>>): Transducer<T, T>;
export declare function distinct<T>(src: Iterable<T>): IterableIterator<T>;
export declare function distinct<T>(opts: Partial<DistinctOpts<T>>, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=distinct.d.ts.map