import type { NumericArray } from "@thi.ng/api";
import type { Reducer } from "./api.js";
/**
 * Reducer which starts filling array with results from given `start` index
 * (default: 0). Use {@link fillN} for typed array targets (same impl, but
 * provides correct result type).
 *
 * @param start -
 */
export declare function fill<T>(start?: number): Reducer<T, T[]>;
export declare function fill<T>(src: Iterable<T>): T[];
export declare function fill<T>(start: number, src: Iterable<T>): T[];
/**
 * Like {@link fill} reducer, but for numeric arrays (incl. typed arrays).
 *
 * @param start -
 */
export declare function fillN(start?: number): Reducer<number, NumericArray>;
export declare function fillN(src: Iterable<number>): NumericArray;
export declare function fillN(start: number, src: Iterable<number>): NumericArray;
//# sourceMappingURL=fill.d.ts.map