import { isIterable } from "@thi.ng/checks/is-iterable";
import { isString } from "@thi.ng/checks/is-string";
import { compR } from "./compr.js";
import { iterator } from "./iterator.js";
import { isReduced } from "./reduced.js";
function flattenWith(fn, src) {
  return isIterable(src) ? iterator(flattenWith(fn), isString(src) ? [src] : src) : (rfn) => {
    const reduce = rfn[2];
    const flatten = (acc, x) => {
      const xx = fn(x);
      if (xx) {
        for (let y of xx) {
          acc = flatten(acc, y);
          if (isReduced(acc)) {
            break;
          }
        }
        return acc;
      }
      return reduce(acc, x);
    };
    return compR(rfn, flatten);
  };
}
export {
  flattenWith
};
