import type { DeepArrayValue } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Recursively flattens input iff it is iterable and NOT a
 * string.
 *
 * @remarks
 * Syntax sugar for {@link flattenWith}. If `src` is given, yields
 * iterator of results.
 *
 * @example
 * ```ts tangle:../export/flatten.ts
 * import { flatten } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...flatten([[1, [2, 3]], ["abc", "cde"]])]
 * );
 * // [1, 2, 3, "abc", "def"]
 *
 * console.log(
 *   [...flatten("abc")]
 * );
 * // [ 'abc' ]
 * ```
 */
export declare function flatten<A, B = DeepArrayValue<A>>(): Transducer<A, B>;
export declare function flatten<A, B = DeepArrayValue<A>>(src: Iterable<A>): IterableIterator<B>;
//# sourceMappingURL=flatten.d.ts.map