import { isIterable } from "@thi.ng/checks/is-iterable";
import { compR } from "./compr.js";
import { iterator } from "./iterator.js";
import { isReduced } from "./reduced.js";
function interpose(sep, src) {
  return isIterable(src) ? iterator(interpose(sep), src) : (rfn) => {
    const r = rfn[2];
    const _sep = typeof sep === "function" ? sep : () => sep;
    let first = true;
    return compR(rfn, (acc, x) => {
      if (first) {
        first = false;
        return r(acc, x);
      }
      acc = r(acc, _sep());
      return isReduced(acc) ? acc : r(acc, x);
    });
  };
}
export {
  interpose
};
