import type { Reducer } from "./api.js";
/**
 * Composes a new reducer from the ones given, in order to produce
 * multiple reductions in parallel from the same input.
 *
 * @remarks
 * The returned reducer produces a result tuple of reduction results,
 * one per reducer. If any of the reducers returns a {@link reduced}
 * result, the reduction process stops for all others too. `juxtR`
 * produces optimized versions for up to 3 reducer args, but can support
 * any number of reducers.
 *
 * @example
 * ```ts tangle:../export/juxtr.ts
 * import { add, juxtR, reduce, reductions, str } from "@thi.ng/transducers";
 *
 * console.log(
 *   reduce(
 *     // use 3 reducers in parallel
 *     juxtR(add(), reductions(add()), str("-")),
 *     [1, 2, 3, 4]
 *   )
 * );
 * // [ 10, [ 0, 1, 3, 6, 10 ], '1-2-3-4' ]
 * ```
 */
export declare function juxtR<A, B1>(r1: Reducer<A, B1>): Reducer<A, [B1]>;
export declare function juxtR<A, B1, B2>(r1: Reducer<A, B1>, r2: Reducer<A, B2>): Reducer<A, [B1, B2]>;
export declare function juxtR<A, B1, B2, B3>(r1: Reducer<A, B1>, r2: Reducer<A, B2>, r3: Reducer<A, B3>): Reducer<A, [B1, B2, B3]>;
export declare function juxtR<A, B1, B2, B3>(r1: Reducer<A, B1>, r2: Reducer<A, B2>, r3: Reducer<A, B3>, ...rs: Reducer<A, any>[]): Reducer<A, any[]>;
//# sourceMappingURL=juxtr.d.ts.map