import { comp } from "./comp.js";
import { __iter } from "./iterator.js";
import { multiplex } from "./multiplex.js";
import { rename } from "./rename.js";
function multiplexObj(...args) {
  const iter = __iter(multiplexObj, args);
  if (iter) {
    return iter;
  }
  const [xforms, rfn] = args;
  const ks = Object.keys(xforms);
  return comp(
    multiplex.apply(null, ks.map((k) => xforms[k])),
    rename(ks, rfn)
  );
}
export {
  multiplexObj
};
