/**
 * Returns the concatentation of `x` with its own duplicate in reverse
 * order. If input is an iterable, it MUST be finite!
 *
 * @remarks
 * In the general case, this is similar to `concat(x, reverse(x))`,
 * though this function keeps input type intact.
 *
 * Uses {@link symmetric}.for all inputs other than arrays or strings.
 *
 * @example
 * ```ts tangle:../export/palindrome.ts
 * import { palindrome, range } from "@thi.ng/transducers";
 *
 * console.log(
 *   palindrome("hello")
 * );
 * // "helloolleh"
 *
 * console.log(
 *   palindrome([1, 2, 3])
 * );
 * // [1, 2, 3, 3, 2, 1]
 *
 * console.log(
 *   [...palindrome(range(3))]
 * );
 * // [ 0, 1, 2, 2, 1, 0 ]
 * ```
 *
 * @param x -
 */
export declare function palindrome(x: string): string;
export declare function palindrome<T>(x: T[]): T[];
export declare function palindrome<T>(x: Iterable<T>): Iterable<T>;
//# sourceMappingURL=palindrome.d.ts.map