import type { Transducer } from "./api.js";
/**
 * Transducer. Yields tumbling, non-overlapping windows/partitions of input
 * values, with the window size defined by given realtime `period` (in
 * milliseconds).
 *
 * @remarks
 * Only to be used in async contexts, NOT with {@link transduce} directly.
 *
 * Also see:
 * - [`thi.ng/transducers-async`](https://thi.ng/transducers-async).
 * - [`thi.ng/rstream`](https://thi.ng/rstream)
 *
 * @example
 * ```ts tangle:../export/partition-time.ts
 * import { fromInterval, trace } from "@thi.ng/rstream";
 * import { partitionTime } from "@thi.ng/transducers";
 *
 * // stream emits counter value every 250ms
 * // callect & partition into tuples every 1000ms
 * fromInterval(250)
 *   .transform(partitionTime(1000))
 *   .subscribe(trace())
 * // [ 0, 1, 2, 3 ]
 * // [ 4, 5, 6, 7 ]
 * // [ 8, 9, 10, 11 ]
 * // [ 12, 13, 14, 15 ]
 * // ...
 * ```
 *
 * @param period - window size (in ms)
 */
export declare function partitionTime<T>(period: number): Transducer<T, T[]>;
export declare function partitionTime<T>(period: number, src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=partition-time.d.ts.map