import { isIterable } from "@thi.ng/checks/is-iterable";
import { iterator } from "./iterator.js";
import { partitionBy } from "./partition-by.js";
function partitionTime(period, src) {
  return isIterable(src) ? iterator(partitionTime(period), src) : partitionBy(() => {
    let last = 0;
    return () => {
      const t = Date.now();
      t - last >= period && (last = t);
      return last;
    };
  }, true);
}
export {
  partitionTime
};
