import type { Transducer } from "./api.js";
/**
 * Transducer to create overlapping and non-overlapping sliding windows
 * of inputs. Window size and progress speed can be configured via
 * `size` and `step`. By default only full / complete partitions are
 * emitted. However, if `all` is true, the last partition is allowed to
 * be incomplete / partially filled only.
 *
 * @example
 * ```ts tangle:../export/partition.ts
 * import { partition, range } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...partition(3, range(10))]
 * );
 * // [ [ 0, 1, 2 ], [ 3, 4, 5 ], [ 6, 7, 8 ] ]
 *
 * console.log(
 *   [...partition(3, true, range(10))]
 * );
 * // [ [ 0, 1, 2 ], [ 3, 4, 5 ], [ 6, 7, 8 ], [ 9 ] ]
 *
 * console.log(
 *   [...partition(3, 1, range(10))]
 * );
 * // [ [ 0, 1, 2 ],
 * //   [ 1, 2, 3 ],
 * //   [ 2, 3, 4 ],
 * //   [ 3, 4, 5 ],
 * //   [ 4, 5, 6 ],
 * //   [ 5, 6, 7 ],
 * //   [ 6, 7, 8 ],
 * //   [ 7, 8, 9 ] ]
 * ```
 *
 * @param size -
 */
export declare function partition<T>(size: number): Transducer<T, T[]>;
export declare function partition<T>(size: number, all: boolean): Transducer<T, T[]>;
export declare function partition<T>(size: number, step: number): Transducer<T, T[]>;
export declare function partition<T>(size: number, step: number, all: boolean): Transducer<T, T[]>;
export declare function partition<T>(size: number, src: Iterable<T>): IterableIterator<T[]>;
export declare function partition<T>(size: number, all: boolean, src: Iterable<T>): IterableIterator<T[]>;
export declare function partition<T>(size: number, step: number, src: Iterable<T>): IterableIterator<T[]>;
export declare function partition<T>(size: number, step: number, all: boolean, src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=partition.d.ts.map