import type { Transducer } from "./api.js";
/**
 * Transducer version of
 * [`peek()`](https://docs.thi.ng/umbrella/arrays/functions/peek.html), i.e.
 * extracts the last item of an array.
 *
 * @example
 * ```ts tangle:../export/peek.ts
 * import { peek } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...peek([ [1, 2, 3], [4, 5] ])]
 * );
 * // [ 3, 5 ]
 * ```
 */
export declare function peek<T>(): Transducer<T[], T>;
export declare function peek<T>(src: Iterable<T[]>): IterableIterator<T>;
//# sourceMappingURL=peek.d.ts.map