import { illegalArity } from "@thi.ng/errors/illegal-arity";
import { range } from "./range.js";
function* range3d(...args) {
  let fromX, toX, stepX;
  let fromY, toY, stepY;
  let fromZ, toZ, stepZ;
  switch (args.length) {
    case 9:
      stepX = args[6];
      stepY = args[7];
      stepZ = args[8];
    case 6:
      [fromX, toX, fromY, toY, fromZ, toZ] = args;
      break;
    case 3:
      [toX, toY, toZ] = args;
      fromX = fromY = fromZ = 0;
      break;
    default:
      illegalArity(args.length);
  }
  const rx = range(fromX, toX, stepX);
  const ry = range(fromY, toY, stepY);
  for (let z of range(fromZ, toZ, stepZ)) {
    for (let y of ry) {
      for (let x of rx) {
        yield [x, y, z];
      }
    }
  }
}
export {
  range3d
};
