import { iterator, __iter } from "./iterator.js";
import { isReduced } from "./reduced.js";
function rechunk(...args) {
  const iter = __iter(rechunk, args, iterator);
  if (iter) return iter;
  return ([init, complete, reduce]) => {
    let buf = "";
    const re = args[0] || /\r?\n/;
    return [
      init,
      (acc) => {
        if (buf) acc = reduce(acc, buf);
        return complete(acc);
      },
      (acc, chunk) => {
        buf += chunk;
        const res = buf.split(re);
        if (res.length > 1) {
          buf = res.pop();
          for (let l of res) {
            acc = reduce(acc, l);
            if (isReduced(acc)) {
              buf = "";
              break;
            }
          }
        }
        return acc;
      }
    ];
  };
}
export {
  rechunk
};
