import type { Fn } from "@thi.ng/api";
import type { IReducible, TxLike } from "./api.js";
/**
 * Transforms `src` with given transducer `tx` and optional side-effect `fx`
 * without any reduction step. If `fx` is given it will be called with every
 * value produced by the transducer. If `fx` is *not* given, the transducer is
 * assumed to include at least one {@link sideEffect} step itself. Returns
 * nothing.
 *
 * @param tx -
 * @param src -
 */
export declare function run<A>(tx: TxLike<A, any>, src: Iterable<A>): void;
export declare function run<A>(tx: TxLike<A, any>, src: IReducible<A, any>): void;
export declare function run<A, B>(tx: TxLike<A, B>, fx: Fn<B, void>, src: Iterable<A>): void;
export declare function run<A, B>(tx: TxLike<A, B>, fx: Fn<B, void>, src: IReducible<A, any>): void;
//# sourceMappingURL=run.d.ts.map