import { __iter, iterator } from "./iterator.js";
import { ensureReduced, isReduced, unreduced } from "./reduced.js";
function scan(...args) {
  return args.length > 2 && __iter(scan, args, iterator) || (([inito, completeo, reduceo]) => {
    const [initi, completei, reducei] = args[0];
    let acc = args.length > 1 && args[1] != null ? args[1] : initi();
    return [
      inito,
      (_acc) => {
        let a = completei(acc);
        if (a !== acc) {
          _acc = unreduced(reduceo(_acc, a));
        }
        acc = a;
        return completeo(_acc);
      },
      (_acc, x) => {
        acc = reducei(acc, x);
        if (isReduced(acc)) {
          return ensureReduced(reduceo(_acc, acc.deref()));
        }
        return reduceo(_acc, acc);
      }
    ];
  });
}
export {
  scan
};
