import { isIterable } from "@thi.ng/checks/is-iterable";
import { clamp0 } from "@thi.ng/math/interval";
import { iterator1 } from "./iterator.js";
import { throttle } from "./throttle.js";
function takeNth(n, src) {
  if (isIterable(src)) {
    return iterator1(takeNth(n), src);
  }
  n = clamp0(n - 1);
  return throttle(() => {
    let skip = 0;
    return () => skip === 0 ? (skip = n, true) : (skip--, false);
  });
}
export {
  takeNth
};
