import type { Predicate } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer which applies predicate `pred` to each input and only
 * yields values as long as the predicate returned a truthy result. Once
 * the result is falsy, transformation is terminated (by emitting a
 * {@link reduced} value).
 *
 * @example
 * ```ts tangle:../export/take-while.ts
 * import { range, takeWhile } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...takeWhile((x) => x < 5, range())]
 * );
 * // [ 0, 1, 2, 3, 4 ]
 * ```
 *
 * @param pred -
 */
export declare function takeWhile<T>(pred?: Predicate<T>): Transducer<T, T>;
export declare function takeWhile<T>(src: Iterable<T>): IterableIterator<T>;
export declare function takeWhile<T>(pred: Predicate<T>, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=take-while.d.ts.map