import type { Predicate, TypedArray } from "@thi.ng/api";
/**
 * Splits array at given index (default: floor(src.length/2)) and returns tuple
 * of [lhs, rhs].
 *
 * @param src -
 * @param index -
 */
export declare function bisect<T>(src: T[], index?: number): [T[], T[]];
export declare function bisect<T extends TypedArray>(src: T, index?: number): [T, T];
/**
 * Similar to {@link bisect}, but first finds split index via provided
 * predicate. The item for which the predicate first returns a truthy result,
 * will be the first item in the RHS array. If the predicate never succeeds, the
 * function returns `[src, []]`, i.e. all items will remain in the LHS.
 *
 * @param src -
 * @param pred -
 */
export declare function bisectWith<T>(src: T[], pred: Predicate<T>): [T[], T[]];
export declare function bisectWith<T extends TypedArray>(src: T, pred: Predicate<number>): [T, T];
//# sourceMappingURL=bisect.d.ts.map