import type { Fn3, Maybe, TypedArray } from "@thi.ng/api";
/**
 * Selectively copies all non-`mask` values from `src` into `dest` starting from
 * destination position `dx`. Returns `dest`.
 *
 * @remarks
 * Where `src` values are the same as `mask`, the corresponding `dest` values
 * will be left unchanged. Performs region clipping, i.e. `dx` can be outside
 * the [0..dest.length) interval.
 *
 * @example
 * ```ts tangle:../export/blit1d.ts
 * import { blit1d } from "@thi.ng/arrays";
 *
 * console.log(
 *   blit1d(
 *      // dest array
 *      [1, 1, 1, 1, 1, 1, 1, 1, 1],
 *      // paste from index 2
 *      2,
 *      // source array
 *      [2, 3, 2, 3, 2],
 *      // mask value
 *      3
 *   )
 * );
 * //[1, 1, 2, 1, 2, 1, 2, 1, 1]
 * ```
 *
 * @param dest
 * @param src
 * @param dx
 * @param mask
 */
export declare function blit1d<T extends TypedArray>(dest: T, dx: number, src: ArrayLike<number>, mask: number): T;
export declare function blit1d<T>(dest: T[], dx: number, src: ArrayLike<T>, mask: T): T[];
/**
 * Similar to {@link blit1d}, but uses a predicate function to
 * determine/transform copied values. The predicate is called with the src, and
 * dest item values and src index. The result of that function is written to the
 * `dest` array. If the predicate returns `undefined`, no value will be written.
 *
 * @param dest
 * @param dx
 * @param src
 * @param pred
 */
export declare function blitPred1d<T extends TypedArray>(dest: T, dx: number, src: ArrayLike<number>, pred: Fn3<number, number, number, Maybe<number>>): T;
export declare function blitPred1d<T>(dest: T[], dx: number, src: ArrayLike<T>, pred: Fn3<T, T, number, Maybe<T>>): T[];
/**
 * 2D version of {@link blit1d} (also with region clipping). Positions and sizes
 * are given as 2D vectors.
 *
 * @param dest
 * @param dpos
 * @param dsize
 * @param src
 * @param ssize
 * @param mask
 */
export declare function blit2d<T extends TypedArray>(dest: T, dpos: ArrayLike<number>, dsize: ArrayLike<number>, src: ArrayLike<number>, ssize: ArrayLike<number>, mask: number): T;
export declare function blit2d<T>(dest: T[], dpos: ArrayLike<number>, dsize: ArrayLike<number>, src: ArrayLike<T>, ssize: ArrayLike<number>, mask: T): T[];
//# sourceMappingURL=blit.d.ts.map