import type { Predicate2 } from "@thi.ng/api";
/**
 * Computes Levenshtein distance w/ optionally given `maxDist` (for
 * early termination, default: ∞) and equality predicate (default:
 * `===`). Returns 0 if both `a` and `b` are equal (based on predicate).
 * Returns `Infinity` if actual distance > `maxDist`.
 *
 * @remarks
 *
 * Based on:
 * - https://en.wikipedia.org/wiki/Levenshtein_distance
 * - https://en.wikipedia.org/wiki/Wagner%E2%80%93Fischer_algorithm
 * - https://github.com/gustf/js-levenshtein/blob/develop/index.js
 *
 * @example
 * ```ts tangle:../export/levenshtein.ts
 * import { levenshtein } from "@thi.ng/arrays";
 *
 * console.log(
 *   levenshtein([1, 2, 3, 4, 5], [1, 2, 4, 3, 5])
 * );
 * // 2
 *
 * console.log(
 *   levenshtein(
 *     [{ id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }],
 *     [{ id: 4 }, { id: 5 }, { id: 3 }, { id: 1 }, { id: 2 }],
 *     // max dist
 *     2,
 *     // predicate
 *     (a, b) => a.id === b.id
 *   )
 * );
 * // Infinity
 * ```
 *
 * @param a -
 * @param b -
 * @param maxDist -
 * @param equiv -
 */
export declare const levenshtein: <T>(a: ArrayLike<T>, b: ArrayLike<T>, maxDist?: number, equiv?: Predicate2<T>) => number;
/**
 * Normalized version of {@link levenshtein}, i.e. the actual L-dist
 * divided by the length of the longest input (or `Infinity` if actual
 * distance > `maxDist`).
 *
 * @param a -
 * @param b -
 * @param maxDist -
 * @param equiv -
 */
export declare const normalizedLevenshtein: <T>(a: ArrayLike<T>, b: ArrayLike<T>, maxDist?: number, equiv?: (a: any, b: any) => boolean) => number;
//# sourceMappingURL=levenshtein.d.ts.map