import type { TypedArray } from "@thi.ng/api";
/**
 * Rotates array by `num` items. If `num < 0` items are rotated left (towards
 * the beginning of the array), otherwise to the right (end). The rotation
 * distance will be `num % buf.length`. The function is no-op if the resulting
 * distance is zero or `buf` is empty.
 *
 * @remarks
 * Not suitable for typed arrays. Use {@link rotateTyped} for those.
 *
 * @param buf
 * @param num
 */
export declare const rotate: <T>(buf: Array<T>, num: number) => T[];
/**
 * Same as {@link rotate}, but for optimized for typed arrays!
 *
 * @param buf
 * @param num
 */
export declare const rotateTyped: (buf: TypedArray, num: number) => TypedArray;
//# sourceMappingURL=rotate.d.ts.map