import type { TypedArray } from "@thi.ng/api";
import type { IRandom } from "@thi.ng/random";
import type { AnyArray } from "./api.js";
/**
 * Shuffles the items in the given index range of array `buf` using Fisher-yates
 * and optional `rnd` PRNG.
 *
 * @remarks
 * If neither `start` / `end` are given, the entire array will be shuffled.
 * Mutates original array.
 *
 * See [`IRandom`](https://docs.thi.ng/umbrella/random/interfaces/IRandom.html)
 *
 * @param buf - array
 * @param n - num items
 * @param rnd - PRNG
 */
export declare const shuffleRange: <T extends AnyArray>(buf: T, start?: number, end?: number, rnd?: IRandom) => T;
/**
 * Applies {@link shuffleRange} to the given array. If `n` is given,
 * only the first `n` items are shuffled. Mutates original array.
 *
 * {@link shuffleRange}
 *
 * @param buf - array
 * @param n - num items
 * @param rnd - PRNG
 */
export declare const shuffle: <T extends any[] | TypedArray>(buf: T, n?: number, rnd?: IRandom) => T;
//# sourceMappingURL=shuffle.d.ts.map