import { assert } from "@thi.ng/errors/assert";
import { SYSTEM } from "@thi.ng/random/system";
const shuffleRange = (buf, start = 0, end = buf.length, rnd = SYSTEM) => {
  assert(
    start >= 0 && end >= start && end <= buf.length,
    `illegal range ${start}..${end}`
  );
  if (end - start > 1) {
    for (let i = end; i-- > start; ) {
      const a = rnd.minmax(start, i + 1) | 0;
      const t = buf[a];
      buf[a] = buf[i];
      buf[i] = t;
    }
  }
  return buf;
};
const shuffle = (buf, n = buf.length, rnd = SYSTEM) => shuffleRange(buf, 0, n, rnd);
export {
  shuffle,
  shuffleRange
};
