import type { FnN } from "@thi.ng/api";
/**
 * Converts signed i8 to unsigned u8 value. Input is assumed to be in
 * [-0x80,0x7f] range. Does NOT perform clamping. Branchless.
 *
 * @param x
 * @returns
 */
export declare const i8u8: FnN;
/**
 * Converts signed i16 to unsigned u16 value. Input is assumed to be in
 * [-0x8000,0x7fff] range. Does NOT perform clamping. Branchless.
 *
 * @param x
 * @returns
 */
export declare const i16u16: FnN;
/**
 * Converts signed i32 to unsigned u32 value. Input is assumed to be in i32
 * range.
 *
 * @param x
 * @returns
 */
export declare const i32u32: FnN;
/**
 * Converts unsigned u8 to signed i8 value. Branchless.
 *
 * @param x
 */
export declare const u8i8: FnN;
/**
 * Converts unsigned u16 to signed i16 value. Branchless.
 *
 * @param x
 */
export declare const u16i16: FnN;
/**
 * Converts unsigned u24 to signed i24 value. Branchless.
 *
 * @param x
 */
export declare const u24i24: FnN;
/**
 * Converts unsigned u32 to signed i32 value.
 *
 * @param x
 */
export declare const u32i32: FnN;
//# sourceMappingURL=int.d.ts.map