import type { FnU2 } from "@thi.ng/api";
/**
 * Creates bit mask by enabling bit `a` to bit `b-1`, both in range
 * 0-32. `b` MUST be >= `a`.
 *
 * @example
 * ```ts tangle:../export/mask.ts
 * import { defMask } from "@thi.ng/binary";
 *
 * console.log(defMask(1,31).toString(16));
 * // 7ffffffe
 *
 * console.log(defMask(3,8).toString(16));
 * // f8
 * ```
 *
 * @param a - first bit
 * @param b - last bit
 */
export declare const defMask: FnU2<number>;
/**
 * Returns unsigned version of `x` with only lowest `n` bits.
 *
 * @param n - number of LSB bits
 * @param x - value
 */
export declare const maskL: FnU2<number>;
/**
 * Returns unsigned version of `x` with only highest `n` bits.
 *
 * @param n - number of MSB bits
 * @param x - value
 */
export declare const maskH: FnU2<number>;
//# sourceMappingURL=mask.d.ts.map