const threadLast = (init, ...fns) => fns.reduce(
  (acc, expr) => typeof expr === "function" ? expr(acc) : expr[0](...expr.slice(1), acc),
  init
);
const threadLastAsync = async (init, ...fns) => {
  let res = await init;
  for (let expr of fns) {
    res = await (typeof expr === "function" ? expr(res) : expr[0](...expr.slice(1), res));
  }
  return res;
};
export {
  threadLast,
  threadLastAsync
};
