/**
 * Hex digits
 */
export declare const HEX = "0123456789abcdef";
/**
 * Returns 4bit uint as hex string
 *
 * @param x -
 */
export declare const U4: (x: number) => string;
/**
 * Returns 8bit uint as hex string
 *
 * @param x -
 */
export declare const U8: (x: number) => string;
/**
 * Returns hex string of 8bit uint, read from given byte array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U8A: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns 16bit uint as hex string
 *
 * @param x -
 */
export declare const U16: (x: number) => string;
/**
 * Returns hex string of 16bit uint, read in big-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U16BE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns hex string of 16bit uint, read in litte-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U16LE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns 24bit uint as hex string
 *
 * @param x -
 */
export declare const U24: (x: number) => string;
/**
 * Returns hex string of 24bit uint, read in big-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U24BE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns hex string of 24bit uint, read in litte-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U24LE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns 32bit uint as hex string
 *
 * @param x -
 */
export declare const U32: (x: number) => string;
/**
 * Returns hex string of 32bit uint, read in big-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U32BE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns hex string of 32bit uint, read in litte-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U32LE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns 48bit uint as hex string
 *
 * @param x -
 */
export declare const U48: (x: number) => string;
/**
 * Similar to {@link U48}, but takes the 64bit arg as 2x 32bit values.
 *
 * @param hi -
 * @param lo -
 */
export declare const U48HL: (hi: number, lo: number) => string;
/**
 * Returns hex string of 48bit uint, read in big-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U48BE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns hex string of 48bit uint, read in litte-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U48LE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns 64bit uint as hex string.
 *
 * @remarks
 * Note: JS numbers are only integer precise up to `2**53 - 1`. Use
 * {@link U64BE} or {@link U64LE} for byte array based values (full 64bit range
 * supported). Alternatively, use `BigInt(x).toString(16)`.
 *
 * Also see {@link U64BIG} for `bigint` version.
 *
 * @param x -
 */
export declare const U64: (x: number) => string;
/**
 * Returns 64bit bigint as hex string.
 *
 * @param x
 */
export declare const U64BIG: (x: bigint) => string;
/**
 * Similar to {@link U64}, but takes the 64bit arg as 2x 32bit values.
 *
 * @param hi -
 * @param lo -
 */
export declare const U64HL: (hi: number, lo: number) => string;
/**
 * Returns hex string of 64bit uint, read in big-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U64BE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns hex string of 64bit uint, read in litte-endian order from given byte
 * array at index `i`.
 *
 * @param x -
 * @param i -
 */
export declare const U64LE: (x: ArrayLike<number>, i: number) => string;
/**
 * Returns UUID formatted string of given byte array from optional start index
 * `i` (default: 0). Array must have min. length 16 (starting from `i`).
 *
 * @param id -
 * @param i -
 */
export declare const uuid: (id: ArrayLike<number>, i?: number) => string;
export declare const hexdump: (bytes: Uint8Array | Uint8ClampedArray, addr: number, len: number, width?: number, ascii?: boolean) => string;
export declare const hexdumpLines: (bytes: Uint8Array | Uint8ClampedArray, addr: number, len: number, width?: number, ascii?: boolean) => string[];
//# sourceMappingURL=index.d.ts.map