import {
  typedArray
} from "@thi.ng/api/typedarray";
class NativePool {
  mallocAs(type, num) {
    return typedArray(type, num);
  }
  callocAs(type, num, fill = 0) {
    return typedArray(type, num).fill(fill);
  }
  reallocArray(src, num) {
    if (num === src.length) return src;
    const dest = new src.constructor(num);
    dest.set(src.subarray(0, Math.min(src.length, num)));
    return dest;
  }
  free(_) {
    return true;
  }
  freeAll() {
  }
  release() {
    return true;
  }
}
export {
  NativePool
};
