import type { FnN, FnN2, FnN3 } from "@thi.ng/api";
/**
 * Returns vector of `[sin(theta)*n, cos(theta)*n]`.
 *
 * @param theta -
 * @param n -
 */
export declare const sincos: (theta: number, n?: number) => [number, number];
/**
 * Returns vector of `[cos(theta)*n, sin(theta)*n]`.
 *
 * @param theta -
 * @param n -
 */
export declare const cossin: (theta: number, n?: number) => [number, number];
/**
 * Projects `theta` into [0 .. 2π] interval.
 *
 * @param theta -
 */
export declare const absTheta: FnN;
export declare const absInnerAngle: FnN;
/**
 * Returns smallest absolute angle difference between `a` and `b`.
 * Result will be in [0 .. π] interval.
 *
 * @param a -
 * @param b -
 */
export declare const angleDist: FnN2;
/**
 * Like `Math.atan2`, but always returns angle in [0 .. TAU) interval.
 *
 * @param y -
 * @param x -
 */
export declare const atan2Abs: FnN2;
/**
 * Returns quadrant ID (0-3) of given angle (in radians).
 *
 * @param theta -
 */
export declare const quadrant: FnN;
/**
 * Converts angle to degrees.
 *
 * @param theta - angle in radians
 */
export declare const deg: FnN;
/**
 * Converts angle to radians.
 *
 * @param theta - angle in degrees
 */
export declare const rad: FnN;
/**
 * Cosecant. Approaches `±Infinity` for `theta` near multiples of π.
 *
 * @param theta - angle in radians
 */
export declare const csc: FnN;
/**
 * Secant. Approaches `±Infinity` for `theta` near π/2 ± nπ
 *
 * @param theta - angle in radians
 */
export declare const sec: FnN;
/**
 * Cotangent. Approaches `±Infinity` for `theta` near multiples of π.
 *
 * @param theta - angle in radians
 */
export declare const cot: FnN;
/**
 * Law of Cosines. Takes length of two sides of a triangle and the inner
 * angle (in radians) between them. Returns length of third side.
 *
 * @param a -
 * @param b -
 * @param gamma -
 */
export declare const loc: FnN3;
/**
 * Approximates cos(xπ) for x in [-1,1]
 *
 * @param x -
 */
export declare const normCos: FnN;
/**
 * Fast cosine approximation using {@link normCos} (polynomial). Max. error
 * ~0.00059693
 *
 * In [0 .. 2π] interval, approx. 18-20% faster than `Math.cos` on V8.
 *
 * @param theta - in radians
 */
export declare const fastCos: FnN;
/**
 * {@link fastCos}
 *
 * @param theta - in radians
 */
export declare const fastSin: FnN;
/**
 * Converts angle from DMS to decimal.
 *
 * @remarks
 * See {@link toDMS} for reverse op.
 *
 * Reference:
 * https://en.wikipedia.org/wiki/Decimal_degrees
 *
 * @param deg
 * @param min
 * @param sec
 */
export declare const fromDMS: (deg: number, min: number, sec: number) => number;
/**
 * Converts decimal angle to DMS. Returns result as 3-tuple with the first item
 * (degrees) having the same sign as the input.
 *
 * @remarks
 * See {@link fromDMS} for reverse op.
 *
 * Reference: https://en.wikipedia.org/wiki/Decimal_degrees
 *
 * @param theta
 */
export declare const toDMS: (theta: number) => number[];
//# sourceMappingURL=angle.d.ts.map