import type { FnU4 } from "@thi.ng/api";
import { type Crossing } from "./api.js";
/**
 * Returns true if line A rises up over B.
 *
 * @example
 * ```text
 * b1  a2
 *   \/
 *   /\
 * a1  b2
 * ```
 *
 * @param a1 -
 * @param a2 -
 * @param b1 -
 * @param b2 -
 */
export declare const isCrossOver: FnU4<number, boolean>;
/**
 * Returns true if line A rises up over B.
 *
 * @example
 * ```text
 * a1  b2
 *   \/
 *   /\
 * b1  a2
 * ```
 *
 * @param a1 -
 * @param a2 -
 * @param b1 -
 * @param b2 -
 */
export declare const isCrossUnder: FnU4<number, boolean>;
/**
 * Returns {@link Crossing} classifier indicating the relationship of line A
 * to line B. The optional epsilon value is used to determine if both
 * lines are considered equal or flat.
 *
 * - {@link isCrossOver}
 * - {@link isCrossUnder}
 * - {@link Crossing}
 *
 * @param a1 -
 * @param a2 -
 * @param b1 -
 * @param b2 -
 * @param eps -
 */
export declare const classifyCrossing: (a1: number, a2: number, b1: number, b2: number, eps?: number) => Crossing;
//# sourceMappingURL=crossing.d.ts.map