import type { FnN3, FnN5 } from "@thi.ng/api";
/**
 * Returns normalized value of `x` WRT to interval `a .. b`. If `a`
 * equals `b`, returns 0.
 *
 * @param x -
 * @param a -
 * @param b -
 */
export declare const norm: FnN3;
/**
 * Returns a number in the `[c,d]` interval which is relative to `x` in the
 * `[a,b]` interval. **No** clamping will be performed if `x` lies outside the
 * original range (for that use {@link fitClamped} instead).
 *
 * @param x
 * @param a
 * @param b
 * @param c
 * @param d
 */
export declare const fit: FnN5;
/**
 * Clamped version of {@link fit}, i.e. before mapping `x` into the target
 * interval `[c,d]`, it will be clamped to the source interval `[a,b]`.
 *
 * @param x
 * @param a
 * @param b
 * @param c
 * @param d
 */
export declare const fitClamped: FnN5;
/**
 * Similar to {@link fitClamped}, assuming [0,1] as source interval.
 *
 * @param x
 * @param a
 * @param b
 */
export declare const fit01: FnN3;
/**
 * Similar to {@link fitClamped}, assuming the reverse ordered [1,0] as source
 * interval.
 *
 * @param x
 * @param a
 * @param b
 */
export declare const fit10: FnN3;
/**
 * Similar to {@link fitClamped}, assuming [-1,1] as source interval.
 *
 * @param x
 * @param a
 * @param b
 */
export declare const fit11: FnN3;
//# sourceMappingURL=fit.d.ts.map