import type { FnN, FnN2, FnN3, FnN4, FnU2, FnU3 } from "@thi.ng/api";
/**
 * Clamps value `x` to given closed interval.
 *
 * @param x - value to clamp
 * @param min - lower bound
 * @param max - upper bound
 */
export declare const clamp: FnN3;
/**
 * Clamps value `x` to closed [0 .. ∞] interval.
 *
 * @param x -
 */
export declare const clamp0: FnN;
/**
 * Clamps value `x` to closed [0 .. 1] interval.
 *
 * @param x -
 */
export declare const clamp01: FnN;
/**
 * Clamps value `x` to closed [-1 .. 1] interval.
 *
 * @param x -
 */
export declare const clamp11: FnN;
/**
 * Clamps value `x` to closed [0 .. 0.5] interval.
 *
 * @param x -
 */
export declare const clamp05: FnN;
/**
 * Returns 2-tuple of [min(x,y), max(x,y)].
 *
 * @param x
 * @param y
 */
export declare const minMax: FnU2<number, [number, number]>;
/**
 * Folds `x` back inside closed [min..max] interval. Also see
 * {@link wrapOnce}.
 *
 * @param x -
 * @param min -
 * @param max -
 */
export declare const wrap: FnN3;
/**
 * Like {@link wrap}, but optimized for cases where `x` is guaranteed to
 * be in `[min - d, max + d]` interval, where `d = max - min`. Result
 * will be in closed `[min..max]` interval.
 *
 * @param x -
 * @param min -
 * @param max -
 */
export declare const wrapOnce: FnN3;
/**
 * Similar to {@link wrapOnce} for [0..1] interval.
 *
 * @param x -
 */
export declare const wrap01: FnN;
/**
 * Similar to {@link wrapOnce} for [-1..1] interval.
 *
 * @param x -
 */
export declare const wrap11: FnN;
export declare const min2id: FnN2;
export declare const min3id: FnN3;
export declare const min4id: FnN4;
export declare const max2id: FnN2;
export declare const max3id: FnN3;
export declare const max4id: FnN4;
/**
 * Returns the non-zero minimum value of the given `a`, `b` args.
 *
 * @param a -
 * @param b -
 */
export declare const minNonZero2: FnN2;
/**
 * Returns the non-zero minimum value of the given `a`, `b`, `c` args.
 *
 * @param a -
 * @param b -
 * @param c -
 */
export declare const minNonZero3: FnN3;
/**
 * See `smax()`.
 *
 * @param a -
 * @param b -
 * @param k - smooth exponent (MUST be > 0)
 */
export declare const smin: FnN3;
/**
 * Smooth maximum. Note: Result values will be slightly larger than max value
 * near max(a,b) + eps due to exponential decay. Higher `k` values reduce the
 * error, but also reduce the smoothing. Recommended k=16.
 *
 * https://en.wikipedia.org/wiki/Smooth_maximum
 *
 * @param a -
 * @param b -
 * @param k - smooth exponent (MUST be > 0)
 */
export declare const smax: FnN3;
/**
 * Same as `smin(smax(x, min, k), max, k)`.
 *
 * @param x -
 * @param min -
 * @param max -
 * @param k -
 */
export declare const sclamp: FnN4;
export declare const absMin: FnN2;
export declare const absMax: FnN2;
/**
 * If `abs(x) > abs(e)`, recursively mirrors `x` back into `[-e .. +e]`
 * interval at respective positive/negative boundary.
 *
 * @remarks
 * References:
 * - https://www.desmos.com/calculator/lkyf2ag3ta
 * - https://www.musicdsp.org/en/latest/Effects/203-fold-back-distortion.html
 *
 * @param e - threshold (> 0)
 * @param x - input value
 */
export declare const foldback: FnN2;
/**
 * Similar to {@link foldback}, but with fixed target range: Folds `x` into the
 * closed [0..1] interval, using infinite internal reflection on either side of
 * the interval.
 *
 * @param x
 */
export declare const foldback01: FnN;
/**
 * Returns true iff `x` is in closed interval `[min .. max]`
 *
 * @param x -
 * @param min -
 * @param max -
 */
export declare const inRange: FnU3<number, boolean>;
/**
 * Returns true iff `x` is in open interval `(min .. max)`
 *
 * @param x -
 * @param min -
 * @param max -
 */
export declare const inOpenRange: FnU3<number, boolean>;
//# sourceMappingURL=interval.d.ts.map