/**
 * Computes factorial for `n`. Throws an error if `n < 0`.
 *
 * @param n
 */
export declare const factorial: (n: number) => number;
/**
 * Computes `n ** k`
 *
 * @param n number of choices
 * @param k number of selected
 */
export declare const permutationsWithRep: (n: number, k: number) => number;
/**
 * Computes `n! / (n - k)!`
 *
 * @remarks
 * Reference:
 * https://en.wikipedia.org/wiki/Permutation#k-permutations_of_n
 *
 * @param n number of choices
 * @param k number of selected
 */
export declare const permutationsWithoutRep: (n: number, k: number) => number;
/**
 * Computes `(n + k - 1)! / (k! * (n - 1)!)`
 *
 * @param n number of choices
 * @param k number of selected
 */
export declare const combinationsWithRep: (n: number, k: number) => number;
/**
 * Computes `n! / (k! * (n - k)!)`
 *
 * @remarks
 * https://en.wikipedia.org/wiki/Combination#Number_of_k-combinations
 *
 * @param n number of choices
 * @param k number of selected
 */
export declare const combinationsWithoutRep: (n: number, k: number) => number;
//# sourceMappingURL=permutations.d.ts.map