import type { FnN, FnN2, FnN3 } from "@thi.ng/api";
/**
 * Step/threshold function.
 *
 * @param edge - threshold
 * @param x - test value
 * @returns 0, if `x < e`, else 1
 */
export declare const step: FnN2;
/**
 * GLSL-style smoothStep threshold function.
 *
 * @remarks
 * Also see {@link smoothStep01}, {@link smootherStep}.
 *
 * @param edge - lower threshold
 * @param edge2 - upper threshold
 * @param x - test value
 * @returns 0, if `x < edge1`, 1 if `x > edge2`, else S-curve polynomial interpolation
 */
export declare const smoothStep: FnN3;
/**
 * Specialized version of {@link smoothStep}, assuming edges are 0/1
 * respectively and `x` is in [0..1]. No clamping performed.
 *
 * @param x
 */
export declare const smoothStep01: FnN;
/**
 * Similar to {@link smoothStep} but using different, higher degree polynomial.
 *
 * @remarks
 * Also see {@link smootherStep01}.
 *
 * @param edge -
 * @param edge2 -
 * @param x -
 */
export declare const smootherStep: FnN3;
/**
 * Specialized version of {@link smootherStep}, assuming edges are 0/1
 * respectively and `x` is in [0..1]. No clamping performed.
 *
 * @param x
 */
export declare const smootherStep01: FnN;
/**
 * Exponential ramp with variable shape
 *
 * @remarks
 * Example configurations:
 *
 * - S-curve: k=8, n=4
 * - Step near 1.0: k=8, n=20
 * - Pulse: k=0.005, n=-10
 * - Ease-in: k=0.5, n=0.25
 *
 * Interactive graph: https://www.desmos.com/calculator/gcnuyppycz
 *
 * @param k -
 * @param n -
 * @param x -
 */
export declare const expStep: FnN3;
//# sourceMappingURL=step.d.ts.map