import type { Fn } from "@thi.ng/api";
import type { MapLike } from "./api.js";
/**
 * Optimized memoization for single arg functions.
 *
 * @remarks
 * If the function expects args other than strings or numbers, you MUST provide
 * a `Map` implementation which supports value (rather than object) equality,
 * e.g. one of those provided by
 * [`thi.ng/associative`](https://thi.ng/associative). Using a native `Map` type
 * here will lead to memory leaks!
 *
 * Also see {@link memoizeO}, {@link memoizeJ}, {@link memoize}.
 *
 * @param fn -
 * @param cache -
 */
export declare const memoize1: <A, B>(fn: Fn<A, B>, cache?: MapLike<A, B>) => (x: A) => B;
//# sourceMappingURL=memoize1.d.ts.map