import type { Fn, Fn2, Fn3, Fn4, IObjectOf } from "@thi.ng/api";
/**
 * Function memoization for arbitrary argument counts. Returns augmented
 * function, which uses `JSON.stringify()` to obtain (and store)
 * memoized result for given args. Supports generics for up to 4 args
 * (otherwise untyped).
 *
 * @remarks
 * **Important:** If the given args cannot be stringified, the user
 * function will ALWAYS be called (without caching result).
 *
 * Also see {@link memoize}, {@link memoize1}, {@link memoizeO}.
 *
 * @param fn -
 * @param cache -
 */
export declare function memoizeJ<A, B>(fn: Fn<A, B>, cache?: IObjectOf<B>): Fn<A, B>;
export declare function memoizeJ<A, B, C>(fn: Fn2<A, B, C>, cache?: IObjectOf<C>): Fn2<A, B, C>;
export declare function memoizeJ<A, B, C, D>(fn: Fn3<A, B, C, D>, cache?: IObjectOf<D>): Fn3<A, B, C, D>;
export declare function memoizeJ<A, B, C, D, E>(fn: Fn4<A, B, C, D, E>, cache?: IObjectOf<E>): Fn4<A, B, C, D, E>;
//# sourceMappingURL=memoizej.d.ts.map