import { ARandom } from "./arandom.js";
const random = Math.random;
class SystemRandom extends ARandom {
  int() {
    return random() * 4294967296 >>> 0;
  }
  float(norm = 1) {
    return random() * norm;
  }
  norm(norm = 1) {
    return (random() - 0.5) * 2 * norm;
  }
}
const SYSTEM = new SystemRandom();
export {
  SYSTEM,
  SystemRandom
};
