import { ARandom } from "./arandom.js";
import { DEFAULT_SEED_32 } from "./constants.js";
class XsAdd extends ARandom {
  buffer;
  constructor(seed = DEFAULT_SEED_32) {
    super();
    this.buffer = new Uint32Array(4);
    this.seed(seed);
  }
  bytes() {
    return new Uint8Array(this.buffer.buffer);
  }
  copy() {
    const gen = new XsAdd();
    gen.buffer.set(this.buffer);
    return gen;
  }
  seed(seed) {
    const s = this.buffer;
    s.set([seed, 0, 0, 0]);
    for (let j = 0, i = 1; i < 8; j = i++) {
      let x = (s[j & 3] ^ s[j & 3] >>> 30) >>> 0;
      x = 35173 * x + ((27655 * x & 65535) << 16) >>> 0;
      s[i & 3] ^= i + x >>> 0;
    }
    return this;
  }
  int() {
    const s = this.buffer;
    let t = s[0];
    t ^= t << 15;
    t ^= t >>> 18;
    t ^= s[3] << 11;
    s[0] = s[1];
    s[1] = s[2];
    s[2] = s[3];
    s[3] = t;
    return t + s[2] >>> 0;
  }
}
export {
  XsAdd
};
