import type { Maybe } from "@thi.ng/api";
import type { SIMD } from "./api.js";
export * from "./api.js";
/**
 * Creates a new WASM module instance w/ user supplied memory. The WASM
 * module itself doesn't use any memory itself and the full address
 * space of the given memory instance is freely available for use. The
 * returned object exposes all SIMD functions defined by this package,
 * as well as various views of the provided memory. See {@link SIMD} interface
 * in api.ts for details.
 *
 * The initialization method used here is synchronous and the WASM
 * binary is inlined as base64 string in this package (The `binary.ts`
 * file is generated during build time).
 *
 * ```js
 * import { init } from "@thi.ng/simd";
 *
 * // create instance w/ 1MB memory (16 * 64KB)
 * simd = init(new WebAssembly.Memory({ initial: 16 }));
 * ```
 *
 * Function will throw an error if WASM is unavailable or underlying
 * runtime doesn't yet support SIMD instructions.
 *
 * @param memory -
 */
export declare const init: (memory: WebAssembly.Memory) => Maybe<SIMD>;
//# sourceMappingURL=index.d.ts.map