import { base64Decode } from "@thi.ng/transducers-binary/base64";
import { BINARY } from "./binary.js";
export * from "./api.js";
const init = (memory) => {
  const buf = memory.buffer;
  return {
    ...new WebAssembly.Instance(
      new WebAssembly.Module(base64Decode(BINARY)),
      {
        env: {
          memory,
          abort(_, file, line, column) {
            console.error(
              `abort called in ${file}: ${line}:${column}`
            );
          }
        }
      }
    ).exports,
    f32: new Float32Array(buf),
    f64: new Float64Array(buf),
    u32: new Uint32Array(buf),
    i32: new Int32Array(buf),
    u16: new Uint16Array(buf),
    i16: new Int16Array(buf),
    u8: new Uint8Array(buf),
    i8: new Int8Array(buf)
  };
};
export {
  init
};
